import AuthService from '../auth-service';

/**
 * 电话联络权限服务对象基类
 *
 * @export
 * @class PhoneCallAuthServiceBase
 * @extends {AuthService}
 */
export default class PhoneCallAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  PhoneCallAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  PhoneCallAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof PhoneCallAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}