import AuthService from '../auth-service';

/**
 * 商机权限服务对象基类
 *
 * @export
 * @class OpportunityAuthServiceBase
 * @extends {AuthService}
 */
export default class OpportunityAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  OpportunityAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  OpportunityAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof OpportunityAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}