import AuthService from '../auth-service';

/**
 * 商机产品权限服务对象基类
 *
 * @export
 * @class OpportunityProductAuthServiceBase
 * @extends {AuthService}
 */
export default class OpportunityProductAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  OpportunityProductAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  OpportunityProductAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof OpportunityProductAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}