import AuthService from '../auth-service';

/**
 * 目标度量权限服务对象基类
 *
 * @export
 * @class MetricAuthServiceBase
 * @extends {AuthService}
 */
export default class MetricAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  MetricAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  MetricAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof MetricAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}