import AuthService from '../auth-service';

/**
 * 营销列表-潜在客户权限服务对象基类
 *
 * @export
 * @class ListLeadAuthServiceBase
 * @extends {AuthService}
 */
export default class ListLeadAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  ListLeadAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ListLeadAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof ListLeadAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}