import AuthService from '../auth-service';

/**
 * 营销列表-账户权限服务对象基类
 *
 * @export
 * @class ListAccountAuthServiceBase
 * @extends {AuthService}
 */
export default class ListAccountAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  ListAccountAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ListAccountAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof ListAccountAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}