import AuthService from '../auth-service';

/**
 * 信件权限服务对象基类
 *
 * @export
 * @class LetterAuthServiceBase
 * @extends {AuthService}
 */
export default class LetterAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  LetterAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  LetterAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof LetterAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}