import AuthService from '../auth-service';

/**
 * 潜在客户对手权限服务对象基类
 *
 * @export
 * @class LeadCompetitorAuthServiceBase
 * @extends {AuthService}
 */
export default class LeadCompetitorAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  LeadCompetitorAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  LeadCompetitorAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof LeadCompetitorAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}