import AuthService from '../auth-service';

/**
 * 知识文章事件权限服务对象基类
 *
 * @export
 * @class KnowledgeArticleIncidentAuthServiceBase
 * @extends {AuthService}
 */
export default class KnowledgeArticleIncidentAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  KnowledgeArticleIncidentAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  KnowledgeArticleIncidentAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof KnowledgeArticleIncidentAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}