import AuthService from '../auth-service';

/**
 * 发票产品权限服务对象基类
 *
 * @export
 * @class InvoiceDetailAuthServiceBase
 * @extends {AuthService}
 */
export default class InvoiceDetailAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  InvoiceDetailAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  InvoiceDetailAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof InvoiceDetailAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}