import AuthService from '../auth-service';

/**
 * 案例客户权限服务对象基类
 *
 * @export
 * @class IncidentCustomerAuthServiceBase
 * @extends {AuthService}
 */
export default class IncidentCustomerAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  IncidentCustomerAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IncidentCustomerAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof IncidentCustomerAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}