import AuthService from '../auth-service';

/**
 * 服务权限服务对象基类
 *
 * @export
 * @class IBizServiceAuthServiceBase
 * @extends {AuthService}
 */
export default class IBizServiceAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  IBizServiceAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBizServiceAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof IBizServiceAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}