import AuthService from '../auth-service';

/**
 * 传真权限服务对象基类
 *
 * @export
 * @class FaxAuthServiceBase
 * @extends {AuthService}
 */
export default class FaxAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  FaxAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  FaxAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof FaxAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}