import AuthService from '../auth-service';

/**
 * 折扣表权限服务对象基类
 *
 * @export
 * @class DiscountTypeAuthServiceBase
 * @extends {AuthService}
 */
export default class DiscountTypeAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  DiscountTypeAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  DiscountTypeAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof DiscountTypeAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}