import AuthService from '../auth-service';

/**
 * 联系人权限服务对象基类
 *
 * @export
 * @class ContactAuthServiceBase
 * @extends {AuthService}
 */
export default class ContactAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  ContactAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ContactAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof ContactAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}