import AuthService from '../auth-service';

/**
 * 竞争对手产品权限服务对象基类
 *
 * @export
 * @class CompetitorProductAuthServiceBase
 * @extends {AuthService}
 */
export default class CompetitorProductAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  CompetitorProductAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  CompetitorProductAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof CompetitorProductAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}