import AuthService from '../auth-service';

/**
 * 市场活动权限服务对象基类
 *
 * @export
 * @class CampaignAuthServiceBase
 * @extends {AuthService}
 */
export default class CampaignAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  CampaignAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  CampaignAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof CampaignAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}