import AuthService from '../auth-service';

/**
 * 快速市场活动权限服务对象基类
 *
 * @export
 * @class BulkOperationAuthServiceBase
 * @extends {AuthService}
 */
export default class BulkOperationAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  BulkOperationAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  BulkOperationAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof BulkOperationAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}