import AuthService from '../auth-service';

/**
 * 客户权限服务对象基类
 *
 * @export
 * @class AccountAuthServiceBase
 * @extends {AuthService}
 */
export default class AccountAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  AccountAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  AccountAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof AccountAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}