import AuthService from '../auth-service';

/**
 * 站点内容权限服务对象基类
 *
 * @export
 * @class WebSiteContentAuthServiceBase
 * @extends {AuthService}
 */
export default class WebSiteContentAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  WebSiteContentAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  WebSiteContentAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof WebSiteContentAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}