import AuthService from '../auth-service';

/**
 * 多类选择实体权限服务对象基类
 *
 * @export
 * @class MultiPickDataAuthServiceBase
 * @extends {AuthService}
 */
export default class MultiPickDataAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  MultiPickDataAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  MultiPickDataAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof MultiPickDataAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}