import AuthService from '../auth-service';

/**
 * 电子邮件权限服务对象基类
 *
 * @export
 * @class EmailAuthServiceBase
 * @extends {AuthService}
 */
export default class EmailAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  EmailAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EmailAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof EmailAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}