import AuthService from '../auth-service';

/**
 * 市场活动-营销列表权限服务对象基类
 *
 * @export
 * @class CampaignListAuthServiceBase
 * @extends {AuthService}
 */
export default class CampaignListAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  CampaignListAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  CampaignListAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof CampaignListAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}