import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import OpportunityService from '@/service/opportunity/opportunity-service';
import QuickCreateService from './quick-create-form-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {QuickCreateEditFormBase}
 */
export class QuickCreateEditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof QuickCreateEditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {QuickCreateService}
     * @memberof QuickCreateEditFormBase
     */
    public service: QuickCreateService = new QuickCreateService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {OpportunityService}
     * @memberof QuickCreateEditFormBase
     */
    public appEntityService: OpportunityService = new OpportunityService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof QuickCreateEditFormBase
     */
    protected appDeName: string = 'opportunity';

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof QuickCreateEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        opportunityname: null,
        parentcontactname: null,
        parentaccountname: null,
        purchasetimeframe: null,
        transactioncurrencyname: null,
        budgetamount: null,
        purchaseprocess: null,
        parentcontactid: null,
        parentaccountid: null,
        transactioncurrencyid: null,
        opportunityid: null,
        opportunity:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof QuickCreateEditFormBase
     */
    public rules: any = {
        opportunityname: [
            { required: true, type: 'string', message: '商机名称 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '商机名称 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof QuickCreateEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '商机基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, uiActionGroup: { caption: '', langbase: 'entities.opportunity.quickcreate_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '商机', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

        srfmajortext: new FormItemModel({ caption: '商机名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        opportunityname: new FormItemModel({ caption: '商机名称', detailType: 'FORMITEM', name: 'opportunityname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        parentcontactname: new FormItemModel({ caption: '联系人', detailType: 'FORMITEM', name: 'parentcontactname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        parentaccountname: new FormItemModel({ caption: '帐户', detailType: 'FORMITEM', name: 'parentaccountname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        purchasetimeframe: new FormItemModel({ caption: '购买时间范围', detailType: 'FORMITEM', name: 'purchasetimeframe', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        transactioncurrencyname: new FormItemModel({ caption: '货币', detailType: 'FORMITEM', name: 'transactioncurrencyname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        budgetamount: new FormItemModel({ caption: '预算金额', detailType: 'FORMITEM', name: 'budgetamount', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        purchaseprocess: new FormItemModel({ caption: '采购程序', detailType: 'FORMITEM', name: 'purchaseprocess', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        parentcontactid: new FormItemModel({ caption: '联系人', detailType: 'FORMITEM', name: 'parentcontactid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        parentaccountid: new FormItemModel({ caption: '帐户', detailType: 'FORMITEM', name: 'parentaccountid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        transactioncurrencyid: new FormItemModel({ caption: '货币', detailType: 'FORMITEM', name: 'transactioncurrencyid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        opportunityid: new FormItemModel({ caption: '商机', detailType: 'FORMITEM', name: 'opportunityid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

    };
}