import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 报价单服务对象基类
 *
 * @export
 * @class QuoteServiceBase
 * @extends {EntityServie}
 */
export default class QuoteServiceBase extends EntityService {

    /**
     * Creates an instance of  QuoteServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  QuoteServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof QuoteServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='quote';
        this.APPDEKEY = 'quoteid';
        this.APPDENAME = 'quotes';
        this.APPDETEXT = 'quotename';
        this.APPNAME = 'crm';
        this.SYSTEMNAME = 'ibizbusinesscentral';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && context.quote){
            return Http.getInstance().get(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/select`,isloading);
        }
        if(context.contact && context.opportunity && context.quote){
            return Http.getInstance().get(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/select`,isloading);
        }
        if(context.account && context.opportunity && context.quote){
            return Http.getInstance().get(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/${context.quote}/select`,isloading);
        }
        if(context.opportunity && context.quote){
            return Http.getInstance().get(`/opportunities/${context.opportunity}/quotes/${context.quote}/select`,isloading);
        }
            return Http.getInstance().get(`/quotes/${context.quote}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && true){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.contact && context.opportunity && true){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.account && context.opportunity && true){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.opportunity && true){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/opportunities/${context.opportunity}/quotes`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/quotes`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.account && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/${context.quote}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/opportunities/${context.opportunity}/quotes/${context.quote}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/quotes/${context.quote}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && context.quote){
            return Http.getInstance().delete(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}`,isloading);
        }
        if(context.contact && context.opportunity && context.quote){
            return Http.getInstance().delete(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}`,isloading);
        }
        if(context.account && context.opportunity && context.quote){
            return Http.getInstance().delete(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/${context.quote}`,isloading);
        }
        if(context.opportunity && context.quote){
            return Http.getInstance().delete(`/opportunities/${context.opportunity}/quotes/${context.quote}`,isloading);
        }
            return Http.getInstance().delete(`/quotes/${context.quote}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && context.quote){
            let res:any = await Http.getInstance().get(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.contact && context.opportunity && context.quote){
            let res:any = await Http.getInstance().get(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.account && context.opportunity && context.quote){
            let res:any = await Http.getInstance().get(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/${context.quote}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.opportunity && context.quote){
            let res:any = await Http.getInstance().get(`/opportunities/${context.opportunity}/quotes/${context.quote}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
            let res:any = await Http.getInstance().get(`/quotes/${context.quote}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && true){
            let res:any = await Http.getInstance().get(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/getdraft`,isloading);
            res.data.quote = data.quote;
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.contact && context.opportunity && true){
            let res:any = await Http.getInstance().get(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/getdraft`,isloading);
            res.data.quote = data.quote;
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.account && context.opportunity && true){
            let res:any = await Http.getInstance().get(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/getdraft`,isloading);
            res.data.quote = data.quote;
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.opportunity && true){
            let res:any = await Http.getInstance().get(`/opportunities/${context.opportunity}/quotes/getdraft`,isloading);
            res.data.quote = data.quote;
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        let res:any = await  Http.getInstance().get(`/quotes/getdraft`,isloading);
        res.data.quote = data.quote;
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
        return res;
    }

    /**
     * Active接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async Active(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/active`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/active`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.account && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/${context.quote}/active`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/opportunities/${context.opportunity}/quotes/${context.quote}/active`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
            return Http.getInstance().post(`/quotes/${context.quote}/active`,data,isloading);
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.account && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/${context.quote}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/opportunities/${context.opportunity}/quotes/${context.quote}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
            return Http.getInstance().post(`/quotes/${context.quote}/checkkey`,data,isloading);
    }

    /**
     * Close接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async Close(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/close`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/close`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.account && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/${context.quote}/close`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/opportunities/${context.opportunity}/quotes/${context.quote}/close`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
            return Http.getInstance().post(`/quotes/${context.quote}/close`,data,isloading);
    }

    /**
     * GenSalesOrder接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async GenSalesOrder(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/gensalesorder`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/gensalesorder`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.account && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/${context.quote}/gensalesorder`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/opportunities/${context.opportunity}/quotes/${context.quote}/gensalesorder`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
            return Http.getInstance().post(`/quotes/${context.quote}/gensalesorder`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.account && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/${context.quote}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/opportunities/${context.opportunity}/quotes/${context.quote}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/quotes/${context.quote}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
    }

    /**
     * Win接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async Win(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/win`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.contact && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/${context.quote}/win`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.account && context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/${context.quote}/win`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
        if(context.opportunity && context.quote){
            let masterData:any = {};
        let quotedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails'),'undefined')){
            quotedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_quotedetails') as any);
            if(quotedetailsData && quotedetailsData.length && quotedetailsData.length > 0){
                quotedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.quotedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.quotedetails = quotedetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/opportunities/${context.opportunity}/quotes/${context.quote}/win`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_quotedetails',JSON.stringify(res.data.quotedetails));
            return res;
        }
            return Http.getInstance().post(`/quotes/${context.quote}/win`,data,isloading);
    }

    /**
     * FetchByParentKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async FetchByParentKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/fetchbyparentkey`,tempData,isloading);
        }
        if(context.contact && context.opportunity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/fetchbyparentkey`,tempData,isloading);
        }
        if(context.account && context.opportunity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/fetchbyparentkey`,tempData,isloading);
        }
        if(context.opportunity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/opportunities/${context.opportunity}/quotes/fetchbyparentkey`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/quotes/fetchbyparentkey`,tempData,isloading);
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof QuoteServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.account && context.contact && context.opportunity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/accounts/${context.account}/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/fetchdefault`,tempData,isloading);
        }
        if(context.contact && context.opportunity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/contacts/${context.contact}/opportunities/${context.opportunity}/quotes/fetchdefault`,tempData,isloading);
        }
        if(context.account && context.opportunity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/accounts/${context.account}/opportunities/${context.opportunity}/quotes/fetchdefault`,tempData,isloading);
        }
        if(context.opportunity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/opportunities/${context.opportunity}/quotes/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/quotes/fetchdefault`,tempData,isloading);
    }
}