/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'eamlocationname',
          prop: 'eamlocationname',
          dataType: 'TEXT',
        },
        {
          name: 'eamlocationid',
          prop: 'eamlocationid',
          dataType: 'GUID',
        },
        {
          name: 'peamlocationname',
          prop: 'peamlocationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eamlocationstateid',
          prop: 'eamlocationstateid',
          dataType: 'PICKUP',
        },
        {
          name: 'peamlocationid',
          prop: 'peamlocationid',
          dataType: 'PICKUP',
        },
        {
          name: 'eamlocationstatename',
          prop: 'eamlocationstatename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eamlocationtypename',
          prop: 'eamlocationtypename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'eamlocationname',
          dataType: 'TEXT',
        },
        {
          name: 'eamlocationtypeid',
          prop: 'eamlocationtypeid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfdataaccaction',
          prop: 'eamlocationid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'eamlocationid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'eamlocation',
          prop: 'eamlocationid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}