import { Subject } from 'rxjs';
import { PickupViewBase } from '@/studio-core';
import EAMLocationStateModelService from '@/service/eamlocation-state-model/eamlocation-state-model-service';
import EAMLocationStateModelAuthService from '@/authservice/eamlocation-state-model/eamlocation-state-model-auth-service';
import PickupViewEngine from '@engine/view/pickup-view-engine';
import EAMLocationStateModelUIService from '@/uiservice/eamlocation-state-model/eamlocation-state-model-ui-service';

/**
 * 功能位置状态模型数据选择视图视图基类
 *
 * @export
 * @class EAMLocationStateModelPickupViewBase
 * @extends {PickupViewBase}
 */
export class EAMLocationStateModelPickupViewBase extends PickupViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStateModelPickupViewBase
     */
    protected appDeName: string = 'eamlocationstatemodel';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStateModelPickupViewBase
     */
    protected appDeKey: string = 'eamlocationstatemodelid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStateModelPickupViewBase
     */
    protected appDeMajor: string = 'eamlocationstatemodelname';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationStateModelService}
     * @memberof EAMLocationStateModelPickupViewBase
     */
    protected appEntityService: EAMLocationStateModelService = new EAMLocationStateModelService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationStateModelUIService
     * @memberof EAMLocationStateModelPickupViewBase
     */
    public appUIService: EAMLocationStateModelUIService = new EAMLocationStateModelUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationStateModelPickupViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationStateModelPickupViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocationstatemodel.views.pickupview.caption',
        srfTitle: 'entities.eamlocationstatemodel.views.pickupview.title',
        srfSubTitle: 'entities.eamlocationstatemodel.views.pickupview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationStateModelPickupViewBase
     */
    protected containerModel: any = {
        view_pickupviewpanel: { name: 'pickupviewpanel', type: 'PICKUPVIEWPANEL' },
        view_okbtn: { name: 'okbtn', type: 'button', text: '确定', disabled: true },
        view_cancelbtn: { name: 'cancelbtn', type: 'button', text: '取消', disabled: false },
        view_leftbtn: { name: 'leftbtn', type: 'button', text: '左移', disabled: true },
        view_rightbtn: { name: 'rightbtn', type: 'button', text: '右移', disabled: true },
        view_allleftbtn: { name: 'allleftbtn', type: 'button', text: '全部左移', disabled: true },
        view_allrightbtn: { name: 'allrightbtn', type: 'button', text: '全部右移', disabled: true },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '3d676a12800fca23bec463d5c5217413';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationStateModelPickupViewBase
     */
    public engine: PickupViewEngine = new PickupViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationStateModelPickupViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            pickupviewpanel: this.$refs.pickupviewpanel,
            keyPSDEField: 'eamlocationstatemodel',
            majorPSDEField: 'eamlocationstatemodelname',
            isLoadDefault: true,
        });
    }

    /**
     * pickupviewpanel 部件 selectionchange 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateModelPickupViewBase
     */
    public pickupviewpanel_selectionchange($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'selectionchange', $event);
    }

    /**
     * pickupviewpanel 部件 activated 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateModelPickupViewBase
     */
    public pickupviewpanel_activated($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'activated', $event);
    }

    /**
     * pickupviewpanel 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateModelPickupViewBase
     */
    public pickupviewpanel_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'load', $event);
    }


}