import { Subject } from 'rxjs';
import { PickupGridViewBase } from '@/studio-core';
import EAMLocationStateModelService from '@/service/eamlocation-state-model/eamlocation-state-model-service';
import EAMLocationStateModelAuthService from '@/authservice/eamlocation-state-model/eamlocation-state-model-auth-service';
import PickupGridViewEngine from '@engine/view/pickup-grid-view-engine';
import EAMLocationStateModelUIService from '@/uiservice/eamlocation-state-model/eamlocation-state-model-ui-service';

/**
 * 功能位置状态模型选择表格视图视图基类
 *
 * @export
 * @class EAMLocationStateModelPickupGridViewBase
 * @extends {PickupGridViewBase}
 */
export class EAMLocationStateModelPickupGridViewBase extends PickupGridViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    protected appDeName: string = 'eamlocationstatemodel';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    protected appDeKey: string = 'eamlocationstatemodelid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    protected appDeMajor: string = 'eamlocationstatemodelname';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationStateModelService}
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    protected appEntityService: EAMLocationStateModelService = new EAMLocationStateModelService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationStateModelUIService
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    public appUIService: EAMLocationStateModelUIService = new EAMLocationStateModelUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationStateModelPickupGridViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocationstatemodel.views.pickupgridview.caption',
        srfTitle: 'entities.eamlocationstatemodel.views.pickupgridview.title',
        srfSubTitle: 'entities.eamlocationstatemodel.views.pickupgridview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    protected containerModel: any = {
        view_grid: { name: 'grid', type: 'GRID' },
        view_searchform: { name: 'searchform', type: 'SEARCHFORM' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = 'bb8b4b03a77ed63b8eb4ef3d62b669a6';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    public engine: PickupGridViewEngine = new PickupGridViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            grid: this.$refs.grid,
            searchform: this.$refs.searchform,
            keyPSDEField: 'eamlocationstatemodel',
            majorPSDEField: 'eamlocationstatemodelname',
            isLoadDefault: true,
        });
    }

    /**
     * grid 部件 selectionchange 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    public grid_selectionchange($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'selectionchange', $event);
    }

    /**
     * grid 部件 beforeload 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    public grid_beforeload($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'beforeload', $event);
    }

    /**
     * grid 部件 rowdblclick 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    public grid_rowdblclick($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'rowdblclick', $event);
    }

    /**
     * grid 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    public grid_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'load', $event);
    }

    /**
     * searchform 部件 save 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    public searchform_save($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('searchform', 'save', $event);
    }

    /**
     * searchform 部件 search 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    public searchform_search($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('searchform', 'search', $event);
    }

    /**
     * searchform 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    public searchform_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('searchform', 'load', $event);
    }



    /**
     * 是否展开搜索表单
     *
     * @protected
     * @type {boolean}
     * @memberof EAMLocationStateModelPickupGridViewBase
     */
    protected isExpandSearchForm: boolean = true;


}