import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 资产备件包服务对象基类
 *
 * @export
 * @class EAMAssetPartsGroupServiceBase
 * @extends {EntityServie}
 */
export default class EAMAssetPartsGroupServiceBase extends EntityService {

    /**
     * Creates an instance of  EAMAssetPartsGroupServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EAMAssetPartsGroupServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EAMAssetPartsGroupServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='eamassetpartsgroup';
        this.APPDEKEY = 'eamassetpartsgroupid';
        this.APPDENAME = 'eamassetpartsgroups';
        this.APPDETEXT = 'eamassetpartsgroupname';
        this.APPNAME = 'assetmanagement';
        this.SYSTEMNAME = 'ibizassetmanagement';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMAssetPartsGroupServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamassetpartsgroup){
            let res:any = Http.getInstance().get(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamassetpartsgroups/${context.eamassetpartsgroup}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/eamassetpartsgroups/${context.eamassetpartsgroup}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMAssetPartsGroupServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamassetpartsgroups`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/eamassetpartsgroups`,data,isloading);
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMAssetPartsGroupServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamassetpartsgroup){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamassetpartsgroups/${context.eamassetpartsgroup}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/eamassetpartsgroups/${context.eamassetpartsgroup}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMAssetPartsGroupServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamassetpartsgroup){
            let res:any = Http.getInstance().delete(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamassetpartsgroups/${context.eamassetpartsgroup}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/eamassetpartsgroups/${context.eamassetpartsgroup}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMAssetPartsGroupServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamassetpartsgroup){
            let res:any = await Http.getInstance().get(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamassetpartsgroups/${context.eamassetpartsgroup}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/eamassetpartsgroups/${context.eamassetpartsgroup}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMAssetPartsGroupServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && true){
            let res:any = await Http.getInstance().get(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamassetpartsgroups/getdraft`,isloading);
            res.data.eamassetpartsgroup = data.eamassetpartsgroup;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/eamassetpartsgroups/getdraft`,isloading);
        res.data.eamassetpartsgroup = data.eamassetpartsgroup;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMAssetPartsGroupServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamassetpartsgroup){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamassetpartsgroups/${context.eamassetpartsgroup}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/eamassetpartsgroups/${context.eamassetpartsgroup}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMAssetPartsGroupServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamassetpartsgroup){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamassetpartsgroups/${context.eamassetpartsgroup}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/eamassetpartsgroups/${context.eamassetpartsgroup}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMAssetPartsGroupServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamassetpartsgroups/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/eamassetpartsgroups/fetchdefault`,tempData,isloading);
        return res;
    }
}