/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'eamassettypename',
          prop: 'eamassettypename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'passetname',
          prop: 'passetname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'assetnumber',
          prop: 'assetnumber',
          dataType: 'TEXT',
        },
        {
          name: 'eamassettypeid',
          prop: 'eamassettypeid',
          dataType: 'PICKUP',
        },
        {
          name: 'eamassetstatename',
          prop: 'eamassetstatename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eamassetstateid',
          prop: 'eamassetstateid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'assetname',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'assetid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'assetid',
          dataType: 'GUID',
        },
        {
          name: 'eamlocationname',
          prop: 'eamlocationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eamlocationid',
          prop: 'eamlocationid',
          dataType: 'PICKUP',
        },
        {
          name: 'passetid',
          prop: 'passetid',
          dataType: 'PICKUP',
        },
        {
          name: 'assetname',
          prop: 'assetname',
          dataType: 'TEXT',
        },
        {
          name: 'eamasset',
          prop: 'assetid',
        },
      {
        name: 'n_assetnumber_like',
        prop: 'n_assetnumber_like',
        dataType: 'TEXT',
      },
      {
        name: 'n_assetname_like',
        prop: 'n_assetname_like',
        dataType: 'TEXT',
      },
      {
        name: 'n_eamassettypename_eq',
        prop: 'n_eamassettypename_eq',
        dataType: 'PICKUPTEXT',
      },
      {
        name: 'n_eamlocationname_eq',
        prop: 'n_eamlocationname_eq',
        dataType: 'PICKUPTEXT',
      },
      {
        name: 'n_eamlocationid_eq',
        prop: 'n_eamlocationid_eq',
      },
      {
        name: 'n_eamassettypeid_eq',
        prop: 'n_eamassettypeid_eq',
      },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}