import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import EAMAssetService from '@/service/eamasset/eamasset-service';
import MainService from './main-grid-service';
import EAMAssetUIService from '@/uiservice/eamasset/eamasset-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {EAMAssetService}
     * @memberof MainGridBase
     */
    public appEntityService: EAMAssetService = new EAMAssetService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'eamasset';

    /**
     * 界面UI服务对象
     *
     * @type {EAMAssetUIService}
     * @memberof MainBase
     */  
    public appUIService:EAMAssetUIService = new EAMAssetUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'eamasset_main_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'assetnumber',
            label: '资产编号',
            langtag: 'entities.eamasset.main_grid.columns.assetnumber',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'assetname',
            label: '资产名称',
            langtag: 'entities.eamasset.main_grid.columns.assetname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'eamassettypename',
            label: '资产类型',
            langtag: 'entities.eamasset.main_grid.columns.eamassettypename',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'eamlocationname',
            label: '功能位置',
            langtag: 'entities.eamasset.main_grid.columns.eamlocationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'passetname',
            label: '上级资产',
            langtag: 'entities.eamasset.main_grid.columns.passetname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'eamassetstatename',
            label: '资产状态',
            langtag: 'entities.eamasset.main_grid.columns.eamassetstatename',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '资产标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '资产标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'assetnumber':false,
        'assetname':false,
        'eamassettypename':false,
        'eamlocationname':false,
        'passetname':false,
        'eamassetstatename':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
        ]);
    }

}