import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 备件包物料服务对象基类
 *
 * @export
 * @class EAMSparePartsPROServiceBase
 * @extends {EntityServie}
 */
export default class EAMSparePartsPROServiceBase extends EntityService {

    /**
     * Creates an instance of  EAMSparePartsPROServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EAMSparePartsPROServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EAMSparePartsPROServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='eamsparepartspro';
        this.APPDEKEY = 'eamsparepartsproid';
        this.APPDENAME = 'eamsparepartspros';
        this.APPDETEXT = 'eamsparepartsproname';
        this.APPNAME = 'assetmanagement';
        this.SYSTEMNAME = 'ibizassetmanagement';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsPROServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamsparepartspro){
            let res:any = Http.getInstance().get(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamsparepartspros/${context.eamsparepartspro}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/eamsparepartspros/${context.eamsparepartspro}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsPROServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamsparepartspros`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/eamsparepartspros`,data,isloading);
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsPROServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamsparepartspro){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamsparepartspros/${context.eamsparepartspro}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/eamsparepartspros/${context.eamsparepartspro}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsPROServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamsparepartspro){
            let res:any = Http.getInstance().delete(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamsparepartspros/${context.eamsparepartspro}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/eamsparepartspros/${context.eamsparepartspro}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsPROServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamsparepartspro){
            let res:any = await Http.getInstance().get(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamsparepartspros/${context.eamsparepartspro}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/eamsparepartspros/${context.eamsparepartspro}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsPROServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && true){
            let res:any = await Http.getInstance().get(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamsparepartspros/getdraft`,isloading);
            res.data.eamsparepartspro = data.eamsparepartspro;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/eamsparepartspros/getdraft`,isloading);
        res.data.eamsparepartspro = data.eamsparepartspro;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsPROServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamsparepartspro){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamsparepartspros/${context.eamsparepartspro}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/eamsparepartspros/${context.eamsparepartspro}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsPROServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && context.eamsparepartspro){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamsparepartspros/${context.eamsparepartspro}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/eamsparepartspros/${context.eamsparepartspro}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsPROServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.eamsparepartsgroup && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/eamsparepartsgroups/${context.eamsparepartsgroup}/eamsparepartspros/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/eamsparepartspros/fetchdefault`,tempData,isloading);
        return res;
    }
}