import AuthService from '../auth-service';

/**
 * 备件包物料权限服务对象基类
 *
 * @export
 * @class EAMSparePartsPROAuthServiceBase
 * @extends {AuthService}
 */
export default class EAMSparePartsPROAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  EAMSparePartsPROAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EAMSparePartsPROAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof EAMSparePartsPROAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}