import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 备件包服务对象基类
 *
 * @export
 * @class EAMSparePartsGroupServiceBase
 * @extends {EntityServie}
 */
export default class EAMSparePartsGroupServiceBase extends EntityService {

    /**
     * Creates an instance of  EAMSparePartsGroupServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EAMSparePartsGroupServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EAMSparePartsGroupServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='eamsparepartsgroup';
        this.APPDEKEY = 'eamsparepartsgroupid';
        this.APPDENAME = 'eamsparepartsgroups';
        this.APPDETEXT = 'eamsparepartsgroupname';
        this.APPNAME = 'assetmanagement';
        this.SYSTEMNAME = 'ibizassetmanagement';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsGroupServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().get(`/eamsparepartsgroups/${context.eamsparepartsgroup}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsGroupServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/eamsparepartsgroups`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_eamassetpartsgroups',JSON.stringify(res.data.eamassetpartsgroups?res.data.eamassetpartsgroups:[]));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_eamsparepartspros',JSON.stringify(res.data.eamsparepartspros?res.data.eamsparepartspros:[]));
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsGroupServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/eamsparepartsgroups/${context.eamsparepartsgroup}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsGroupServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().delete(`/eamsparepartsgroups/${context.eamsparepartsgroup}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsGroupServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/eamsparepartsgroups/${context.eamsparepartsgroup}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsGroupServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/eamsparepartsgroups/getdraft`,isloading);
        res.data.eamsparepartsgroup = data.eamsparepartsgroup;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsGroupServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/eamsparepartsgroups/${context.eamsparepartsgroup}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsGroupServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/eamsparepartsgroups/${context.eamsparepartsgroup}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EAMSparePartsGroupServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/eamsparepartsgroups/fetchdefault`,tempData,isloading);
        return res;
    }
}