import { Subject } from 'rxjs';
import { TabExpViewBase } from '@/studio-core';
import EAMSparePartsGroupService from '@/service/eamspare-parts-group/eamspare-parts-group-service';
import EAMSparePartsGroupAuthService from '@/authservice/eamspare-parts-group/eamspare-parts-group-auth-service';
import TabExpViewEngine from '@engine/view/tab-exp-view-engine';
import EAMSparePartsGroupUIService from '@/uiservice/eamspare-parts-group/eamspare-parts-group-ui-service';

/**
 * 备件包信息视图基类
 *
 * @export
 * @class EAMSparePartsGroupInfoViewBase
 * @extends {TabExpViewBase}
 */
export class EAMSparePartsGroupInfoViewBase extends TabExpViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMSparePartsGroupInfoViewBase
     */
    protected appDeName: string = 'eamsparepartsgroup';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMSparePartsGroupInfoViewBase
     */
    protected appDeKey: string = 'eamsparepartsgroupid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMSparePartsGroupInfoViewBase
     */
    protected appDeMajor: string = 'eamsparepartsgroupname';

    /**
     * 实体服务对象
     *
     * @type {EAMSparePartsGroupService}
     * @memberof EAMSparePartsGroupInfoViewBase
     */
    protected appEntityService: EAMSparePartsGroupService = new EAMSparePartsGroupService;

    /**
     * 实体权限服务对象
     *
     * @type EAMSparePartsGroupUIService
     * @memberof EAMSparePartsGroupInfoViewBase
     */
    public appUIService: EAMSparePartsGroupUIService = new EAMSparePartsGroupUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMSparePartsGroupInfoViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMSparePartsGroupInfoViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamsparepartsgroup.views.infoview.caption',
        srfTitle: 'entities.eamsparepartsgroup.views.infoview.title',
        srfSubTitle: 'entities.eamsparepartsgroup.views.infoview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMSparePartsGroupInfoViewBase
     */
    protected containerModel: any = {
        view_tabexppanel: { name: 'tabexppanel', type: 'TABEXPPANEL' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '9d4bfdacbd01e6a5072e50c5ecb24e70';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMSparePartsGroupInfoViewBase
     */
    public engine: TabExpViewEngine = new TabExpViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMSparePartsGroupInfoViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            keyPSDEField: 'eamsparepartsgroup',
            majorPSDEField: 'eamsparepartsgroupname',
            isLoadDefault: true,
        });
    }


}