import { ViewTool } from '@/utils';

/**
 * AppIndexView 部件模型
 *
 * @export
 * @class AppIndexViewModel
 */
export default class AppIndexViewModel {

    /**
     * 菜单项集合
     *
     * @private
     * @type {any[]}
     * @memberof AppIndexViewModel
     */
    private items: any[] = [
                {
        	id: 'A20112C0-6FC7-48FC-B14C-24C66A924503',
        	name: 'user_menus',
        	text: '用户菜单',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '用户菜单',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        }
        ,
                {
        	id: '70669C0B-37A4-4121-95D8-DCCB0827F20D',
        	name: 'top_menus',
        	text: '顶部菜单',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '顶部菜单',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        	items: [
                		        {
                	id: '72EF9A96-DED9-4262-8219-3212E7A332B6',
                	name: 'menuitem15',
                	text: '系统设置',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '系统设置',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-cog',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: '2EC2E657-B9FB-4ABF-B936-97222E18BB74',
                        	name: 'menuitem21',
                        	text: '文档类型',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '文档类型',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-file',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_18',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamdocument-type-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '0F6F0CEA-5965-4D70-AD5E-F149819CAA76',
                        	name: 'menuitem16',
                        	text: '服务等级',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '服务等级',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-server',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_16',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamservice-level-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '7C4D180A-5AC9-451E-A7BE-969707F6E5E9',
                        	name: 'menuitem17',
                        	text: '维护申请类型',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '维护申请类型',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-legal',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_5',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamapply-type-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '736DEC4C-072F-49B9-AAD5-C8B13A10B55C',
                        	name: 'menuitem19',
                        	text: '工单类型',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '工单类型',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-legal',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_7',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamwotype-grid-view',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
        	],
        }
        ,
                {
        	id: '7428CF1E-09D0-477F-838B-3CB98A776FBA',
        	name: 'left_exp',
        	text: '左侧菜单',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '左侧菜单',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        	items: [
                		        {
                	id: '8739EFEE-ED1F-40E0-9BDB-438466E895D7',
                	name: 'menuitem1',
                	text: '功能位置',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '功能位置',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-navicon',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: '83E50A95-6762-4A67-9052-69DE75A60E3B',
                        	name: 'menuitem6',
                        	text: '功能位置状态',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '功能位置状态',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-life-ring',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_10',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamlocation-state-list-exp-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: 'E3BFAB38-B5C1-487A-B68B-61F6EF513C58',
                        	name: 'menuitem7',
                        	text: '功能位置状态模型',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '功能位置状态模型',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-cube',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_9',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamlocation-state-model-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '6B6D828E-5B2A-4DF2-B437-0DDD328DAD7D',
                        	name: 'menuitem8',
                        	text: '功能位置类型',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '功能位置类型',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-legal',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_12',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamlocation-type-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '6E2E7A7B-EDEF-460B-84A7-A2777BDD996E',
                        	name: 'menuitem9',
                        	text: '功能位置',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '功能位置',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-navicon',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_15',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamlocation-tree-exp-view',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
                		        {
                	id: '78652037-98D2-48D1-8600-4DBFCD9243F0',
                	name: 'menuitem2',
                	text: '资产管理',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '资产管理',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-rocket',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: 'F78D316F-28EB-49D9-AFD1-B34393D208BD',
                        	name: 'menuitem10',
                        	text: '资产状态',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '资产状态',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-life-ring',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_3',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamasset-state-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '209538AE-367C-4976-A2A7-5C40C622BF7F',
                        	name: 'menuitem11',
                        	text: '资产状态模型',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '资产状态模型',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-cube',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_4',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamasset-state-model-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '6EC21D36-D7FB-4684-8448-DACEFCE5B0A5',
                        	name: 'menuitem12',
                        	text: '资产类型',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '资产类型',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-legal',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_14',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamasset-type-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '4E96FE14-1C7E-4C47-8FDE-444B19EAB2A5',
                        	name: 'menuitem13',
                        	text: '资产管理',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '资产管理',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-rocket',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_13',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamasset-tree-exp-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '5AF50A95-EA23-4E22-B354-FFA3CBD58356',
                        	name: 'menuitem22',
                        	text: '文档',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '文档',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-files-o',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_2',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamdocument-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: 'D457B927-86B5-4607-B8D6-6774ACF2D8E8',
                        	name: 'menuitem14',
                        	text: '备件包',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '备件包',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-instagram',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_8',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamspare-parts-group-grid-view',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
                		        {
                	id: '4803F5BD-7CF9-4A67-BCA6-DCB022B56291',
                	name: 'menuitem4',
                	text: '工单管理',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '工单管理',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-file-word-o',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: '5FD0497E-7F0C-4AFA-931A-64FECFAD6B0D',
                        	name: 'menuitem3',
                        	text: '维护申请',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '维护申请',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-share-square',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_11',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamapply-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '885534EC-341F-4B11-A754-A23EDEF10B24',
                        	name: 'menuitem18',
                        	text: '工单',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '工单',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-file-word-o',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_6',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamwork-order-grid-view',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
                		        {
                	id: '38802802-F256-487F-B526-7E2A58541A6C',
                	name: 'menuitem5',
                	text: '维护计划',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '维护计划',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-calendar',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: '248932F0-F1F3-4B4F-B1B1-21C82C74A217',
                        	name: 'menuitem20',
                        	text: '维护计划',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '维护计划',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-calendar',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_17',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'eamplan-grid-view',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
        	],
        }
        ,
    ];

	/**
	 * 应用功能集合
	 *
	 * @private
	 * @type {any[]}
	 * @memberof AppIndexViewModel
	 */
	private funcs: any[] = [
        {
            appfunctag: '_14',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamassettypegridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamassettypes/:eamassettype?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamassettypes', parameterName: 'eamassettype' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_15',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamlocationtreeexpview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamlocations/:eamlocation?/treeexpview/:treeexpview?',
            parameters: [
                { pathName: 'eamlocations', parameterName: 'eamlocation' },
                { pathName: 'treeexpview', parameterName: 'treeexpview' },
            ],
        },
        {
            appfunctag: '_18',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamdocumenttypegridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamdocumenttypes/:eamdocumenttype?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamdocumenttypes', parameterName: 'eamdocumenttype' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_3',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamassetstategridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamassetstates/:eamassetstate?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamassetstates', parameterName: 'eamassetstate' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_17',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamplangridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamplans/:eamplan?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamplans', parameterName: 'eamplan' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_5',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamapplytypegridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamapplytypes/:eamapplytype?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamapplytypes', parameterName: 'eamapplytype' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_16',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamservicelevelgridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamservicelevels/:eamservicelevel?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamservicelevels', parameterName: 'eamservicelevel' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_13',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamassettreeexpview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamassets/:eamasset?/treeexpview/:treeexpview?',
            parameters: [
                { pathName: 'eamassets', parameterName: 'eamasset' },
                { pathName: 'treeexpview', parameterName: 'treeexpview' },
            ],
        },
        {
            appfunctag: '_6',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamworkordergridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamworkorders/:eamworkorder?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamworkorders', parameterName: 'eamworkorder' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_2',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamdocumentgridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamdocuments/:eamdocument?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamdocuments', parameterName: 'eamdocument' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_9',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamlocationstatemodelgridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamlocationstatemodels/:eamlocationstatemodel?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_10',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamlocationstatelistexpview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamlocationstates/:eamlocationstate?/listexpview/:listexpview?',
            parameters: [
                { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                { pathName: 'listexpview', parameterName: 'listexpview' },
            ],
        },
        {
            appfunctag: '_12',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamlocationtypegridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamlocationtypes/:eamlocationtype?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamlocationtypes', parameterName: 'eamlocationtype' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_4',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamassetstatemodelgridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamassetstatemodels/:eamassetstatemodel?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamassetstatemodels', parameterName: 'eamassetstatemodel' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_8',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamsparepartsgroupgridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamsparepartsgroups/:eamsparepartsgroup?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamsparepartsgroups', parameterName: 'eamsparepartsgroup' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_7',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamwotypegridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamwotypes/:eamwotype?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamwotypes', parameterName: 'eamwotype' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_11',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'eamapplygridview',
            deResParameters: [],
            routepath: '/appindexview/:appindexview?/eamapplies/:eamapply?/gridview/:gridview?',
            parameters: [
                { pathName: 'eamapplies', parameterName: 'eamapply' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
	];

	/**
	 * 根据当前路由查找激活菜单
	 *
	 * @param {*} route
	 * @returns {*}
	 * @memberof AppIndexViewModel
	 */
	public findActiveMenuByRoute(route: any): any {
		if (route) {
			const func = this.funcs.find((item: any) => {
				if (item.openmode === '') {
					const url: string = ViewTool.buildUpRoutePath(route, route.params, [], item.parameters, [], {});
					return url === route.fullPath;
				}
			});
            if (func) {
			    return this.findMenuByFuncTag(func.appfunctag);
            }
		}
	}

	/**
	 * 根据应用功能id查找菜单项
	 *
	 * @param {string} tag
	 * @param {any[]} [menus=this.items]
	 * @returns {*}
	 * @memberof AppIndexViewModel
	 */
	public findMenuByFuncTag(tag: string, menus: any[] = this.items): any {
		let menu: any;
		menus.every((item: any) => {
			if (item.appfunctag === tag) {
				menu = item;
				return false;
			}
			if (item.items) {
				menu = this.findMenuByFuncTag(tag, item.items);
				if (menu) {
					return false;
				}
			}
			return true;
		});
		return menu;
	}

	/**
	 * 查找默认打开菜单
	 *
	 * @param {any[]} [menus=this.items]
	 * @returns {*}
	 * @memberof AppIndexViewModel
	 */
	public findDefaultOpenMenu(menus: any[] = this.items): any {
		let menu: any;
		menus.every((item: any) => {
			if (item.opendefault === true) {
				menu = item;
				return false;
			}
			if (item.items) {
				menu = this.findMenuByFuncTag(item.items);
				if (menu) {
					return false;
				}
			}
			return true;
		});
		return menu;
	}

    /**
     * 获取所有菜单项集合
     *
     * @returns {any[]}
     * @memberof AppIndexViewModel
     */
    public getAppMenuItems(): any[] {
        return this.items;
    }

	/**
	 * 根据名称获取菜单组
	 *
	 * @param {string} name
	 * @returns {*}
	 * @memberof AppIndexViewModel
	 */
	public getMenuGroup(name: string): any {
		return this.items.find((item: any) => Object.is(item.name, name));
	}

    /**
     * 获取所有应用功能集合
     *
     * @returns {any[]}
     * @memberof AppIndexViewModel
     */
    public getAppFuncs(): any[] {
        return this.funcs;
    }
}