import { Subject } from 'rxjs';
import { DashboardViewBase } from '@/studio-core';
import EAMLocationService from '@/service/eamlocation/eamlocation-service';
import EAMLocationAuthService from '@/authservice/eamlocation/eamlocation-auth-service';
import PortalViewEngine from '@engine/view/portal-view-engine';
import EAMLocationUIService from '@/uiservice/eamlocation/eamlocation-ui-service';

/**
 * 功能位置数据看板视图视图基类
 *
 * @export
 * @class EAMLocationSummaryViewBase
 * @extends {DashboardViewBase}
 */
export class EAMLocationSummaryViewBase extends DashboardViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationSummaryViewBase
     */
    protected appDeName: string = 'eamlocation';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationSummaryViewBase
     */
    protected appDeKey: string = 'eamlocationid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationSummaryViewBase
     */
    protected appDeMajor: string = 'eamlocationname';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationService}
     * @memberof EAMLocationSummaryViewBase
     */
    protected appEntityService: EAMLocationService = new EAMLocationService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationUIService
     * @memberof EAMLocationSummaryViewBase
     */
    public appUIService: EAMLocationUIService = new EAMLocationUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationSummaryViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationSummaryViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocation.views.summaryview.caption',
        srfTitle: 'entities.eamlocation.views.summaryview.title',
        srfSubTitle: 'entities.eamlocation.views.summaryview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationSummaryViewBase
     */
    protected containerModel: any = {
        view_dashboard: { name: 'dashboard', type: 'DASHBOARD' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = 'cc29cbcb0398aa069d4b05f3469f0377';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationSummaryViewBase
     */
    public engine: PortalViewEngine = new PortalViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationSummaryViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            dashboard: this.$refs.dashboard,
            keyPSDEField: 'eamlocation',
            majorPSDEField: 'eamlocationname',
            isLoadDefault: true,
        });
    }

    /**
     * dashboard 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationSummaryViewBase
     */
    public dashboard_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('dashboard', 'load', $event);
    }


}