import { Subject } from 'rxjs';
import { PickupGridViewBase } from '@/studio-core';
import EAMLocationStateService from '@/service/eamlocation-state/eamlocation-state-service';
import EAMLocationStateAuthService from '@/authservice/eamlocation-state/eamlocation-state-auth-service';
import PickupGridViewEngine from '@engine/view/pickup-grid-view-engine';
import EAMLocationStateUIService from '@/uiservice/eamlocation-state/eamlocation-state-ui-service';

/**
 * 功能位置状态信息视图基类
 *
 * @export
 * @class EAMLocationStatePickupGridViewBase
 * @extends {PickupGridViewBase}
 */
export class EAMLocationStatePickupGridViewBase extends PickupGridViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStatePickupGridViewBase
     */
    protected appDeName: string = 'eamlocationstate';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStatePickupGridViewBase
     */
    protected appDeKey: string = 'eamlocationstateid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStatePickupGridViewBase
     */
    protected appDeMajor: string = 'eamlocationstatename';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationStateService}
     * @memberof EAMLocationStatePickupGridViewBase
     */
    protected appEntityService: EAMLocationStateService = new EAMLocationStateService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationStateUIService
     * @memberof EAMLocationStatePickupGridViewBase
     */
    public appUIService: EAMLocationStateUIService = new EAMLocationStateUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationStatePickupGridViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationStatePickupGridViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocationstate.views.pickupgridview.caption',
        srfTitle: 'entities.eamlocationstate.views.pickupgridview.title',
        srfSubTitle: 'entities.eamlocationstate.views.pickupgridview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationStatePickupGridViewBase
     */
    protected containerModel: any = {
        view_grid: { name: 'grid', type: 'GRID' },
        view_searchform: { name: 'searchform', type: 'SEARCHFORM' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = 'b56347aaab650c59a8338876600c21e4';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationStatePickupGridViewBase
     */
    public engine: PickupGridViewEngine = new PickupGridViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationStatePickupGridViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            grid: this.$refs.grid,
            searchform: this.$refs.searchform,
            keyPSDEField: 'eamlocationstate',
            majorPSDEField: 'eamlocationstatename',
            isLoadDefault: true,
        });
    }

    /**
     * grid 部件 selectionchange 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStatePickupGridViewBase
     */
    public grid_selectionchange($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'selectionchange', $event);
    }

    /**
     * grid 部件 beforeload 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStatePickupGridViewBase
     */
    public grid_beforeload($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'beforeload', $event);
    }

    /**
     * grid 部件 rowdblclick 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStatePickupGridViewBase
     */
    public grid_rowdblclick($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'rowdblclick', $event);
    }

    /**
     * grid 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStatePickupGridViewBase
     */
    public grid_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'load', $event);
    }

    /**
     * searchform 部件 save 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStatePickupGridViewBase
     */
    public searchform_save($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('searchform', 'save', $event);
    }

    /**
     * searchform 部件 search 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStatePickupGridViewBase
     */
    public searchform_search($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('searchform', 'search', $event);
    }

    /**
     * searchform 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStatePickupGridViewBase
     */
    public searchform_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('searchform', 'load', $event);
    }



    /**
     * 是否展开搜索表单
     *
     * @protected
     * @type {boolean}
     * @memberof EAMLocationStatePickupGridViewBase
     */
    protected isExpandSearchForm: boolean = true;


}