import { Subject } from 'rxjs';
import { EditViewBase } from '@/studio-core';
import EAMLocationStateService from '@/service/eamlocation-state/eamlocation-state-service';
import EAMLocationStateAuthService from '@/authservice/eamlocation-state/eamlocation-state-auth-service';
import EditViewEngine from '@engine/view/edit-view-engine';
import EAMLocationStateUIService from '@/uiservice/eamlocation-state/eamlocation-state-ui-service';

/**
 * 功能位置状态信息视图基类
 *
 * @export
 * @class EAMLocationStateEditViewBase
 * @extends {EditViewBase}
 */
export class EAMLocationStateEditViewBase extends EditViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStateEditViewBase
     */
    protected appDeName: string = 'eamlocationstate';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStateEditViewBase
     */
    protected appDeKey: string = 'eamlocationstateid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStateEditViewBase
     */
    protected appDeMajor: string = 'eamlocationstatename';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationStateService}
     * @memberof EAMLocationStateEditViewBase
     */
    protected appEntityService: EAMLocationStateService = new EAMLocationStateService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationStateUIService
     * @memberof EAMLocationStateEditViewBase
     */
    public appUIService: EAMLocationStateUIService = new EAMLocationStateUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationStateEditViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationStateEditViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocationstate.views.editview.caption',
        srfTitle: 'entities.eamlocationstate.views.editview.title',
        srfSubTitle: 'entities.eamlocationstate.views.editview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationStateEditViewBase
     */
    protected containerModel: any = {
        view_form: { name: 'form', type: 'FORM' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '0b6fa9e6ebc1f6d1afaf3c19585840b0';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationStateEditViewBase
     */
    public engine: EditViewEngine = new EditViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationStateEditViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            form: this.$refs.form,
            p2k: '0',
            keyPSDEField: 'eamlocationstate',
            majorPSDEField: 'eamlocationstatename',
            isLoadDefault: true,
        });
    }

    /**
     * form 部件 save 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateEditViewBase
     */
    public form_save($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'save', $event);
    }

    /**
     * form 部件 remove 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateEditViewBase
     */
    public form_remove($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'remove', $event);
    }

    /**
     * form 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStateEditViewBase
     */
    public form_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'load', $event);
    }


}