import AuthService from '../auth-service';

/**
 * 维护计划权限服务对象基类
 *
 * @export
 * @class EAMPlanAuthServiceBase
 * @extends {AuthService}
 */
export default class EAMPlanAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  EAMPlanAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EAMPlanAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof EAMPlanAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}