/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'sortnumber',
          prop: 'sortnumber',
          dataType: 'INT',
        },
        {
          name: 'srfmajortext',
          prop: 'eamplanlinename',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'eamplanlineid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'eamplanlineid',
          dataType: 'GUID',
        },
        {
          name: 'eamlocationname',
          prop: 'eamlocationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'content',
          prop: 'content',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'eamlocationid',
          prop: 'eamlocationid',
          dataType: 'PICKUP',
        },
        {
          name: 'eammonitorpointid',
          prop: 'eammonitorpointid',
          dataType: 'PICKUP',
        },
        {
          name: 'eamplanid',
          prop: 'eamplanid',
          dataType: 'PICKUP',
        },
        {
          name: 'eamplanlinename',
          prop: 'eamplanlinename',
          dataType: 'TEXT',
        },
        {
          name: 'eamplanname',
          prop: 'eamplanname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'assetid',
          prop: 'assetid',
          dataType: 'PICKUP',
        },
        {
          name: 'assetname',
          prop: 'assetname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eamplanline',
          prop: 'eamplanlineid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}