import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import EAMPlanLineService from '@/service/eamplan-line/eamplan-line-service';
import MainService from './main-form-service';
import EAMPlanLineUIService from '@/uiservice/eamplan-line/eamplan-line-ui-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {MainEditFormBase}
 */
export class MainEditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainEditFormBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {EAMPlanLineService}
     * @memberof MainEditFormBase
     */
    public appEntityService: EAMPlanLineService = new EAMPlanLineService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected appDeName: string = 'eamplanline';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected appDeLogicName: string = '计划步骤';
    /**
     * 界面UI服务对象
     *
     * @type {EAMPlanLineUIService}
     * @memberof MainEditFormBase
     */  
    public appUIService:EAMPlanLineUIService = new EAMPlanLineUIService(this.$store);


    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        sortnumber: null,
        eamplanlinename: null,
        eamplanname: null,
        content: null,
        assetname: null,
        eamlocationname: null,
        eammonitorpointname: null,
        eamlocationid: null,
        eammonitorpointid: null,
        eamplanid: null,
        eamplanlineid: null,
        assetid: null,
        eamplanline:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public rules: any = {
        sortnumber: [
            { required: true, type: 'number', message: '序号 值不能为空', trigger: 'change' },
            { required: true, type: 'number', message: '序号 值不能为空', trigger: 'blur' },
        ],
        eamplanlinename: [
            { required: true, type: 'string', message: '计划步骤名称 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '计划步骤名称 值不能为空', trigger: 'blur' },
        ],
        eamplanname: [
            { required: true, type: 'string', message: '维护计划 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '维护计划 值不能为空', trigger: 'blur' },
        ],
        assetname: [
            { required: true, type: 'string', message: '资产 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '资产 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainBase
     */
    public deRules:any = {
    };

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: true, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.eamplanline.main_form', extractMode: 'ITEM', details: [] } }),

        grouppanel1: new FormGroupPanelModel({ caption: '资产信息', detailType: 'GROUPPANEL', name: 'grouppanel1', visible: true, isShowCaption: true, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.eamplanline.main_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this, showMoreMode: 0 }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '计划步骤标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfmajortext: new FormItemModel({ caption: '计划步骤名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        sortnumber: new FormItemModel({ caption: '序号', detailType: 'FORMITEM', name: 'sortnumber', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamplanlinename: new FormItemModel({ caption: '计划步骤名称', detailType: 'FORMITEM', name: 'eamplanlinename', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamplanname: new FormItemModel({ caption: '维护计划', detailType: 'FORMITEM', name: 'eamplanname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        content: new FormItemModel({ caption: '内容', detailType: 'FORMITEM', name: 'content', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        assetname: new FormItemModel({ caption: '资产', detailType: 'FORMITEM', name: 'assetname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamlocationname: new FormItemModel({ caption: '功能位置', detailType: 'FORMITEM', name: 'eamlocationname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eammonitorpointname: new FormItemModel({ caption: '测点', detailType: 'FORMITEM', name: 'eammonitorpointname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamlocationid: new FormItemModel({ caption: '功能位置标识', detailType: 'FORMITEM', name: 'eamlocationid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eammonitorpointid: new FormItemModel({ caption: '测点标识', detailType: 'FORMITEM', name: 'eammonitorpointid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamplanid: new FormItemModel({ caption: '维护计划标识', detailType: 'FORMITEM', name: 'eamplanid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamplanlineid: new FormItemModel({ caption: '计划步骤标识', detailType: 'FORMITEM', name: 'eamplanlineid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        assetid: new FormItemModel({ caption: '资产标识', detailType: 'FORMITEM', name: 'assetid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

    };
}