import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import EAMLocationService from '@/service/eamlocation/eamlocation-service';
import EF_001Service from './ef-001-form-service';
import EAMLocationUIService from '@/uiservice/eamlocation/eamlocation-ui-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {EF_001EditFormBase}
 */
export class EF_001EditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof EF_001EditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {EF_001Service}
     * @memberof EF_001EditFormBase
     */
    public service: EF_001Service = new EF_001Service({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {EAMLocationService}
     * @memberof EF_001EditFormBase
     */
    public appEntityService: EAMLocationService = new EAMLocationService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EF_001EditFormBase
     */
    protected appDeName: string = 'eamlocation';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof EF_001EditFormBase
     */
    protected appDeLogicName: string = '功能位置';
    /**
     * 界面UI服务对象
     *
     * @type {EAMLocationUIService}
     * @memberof EF_001EditFormBase
     */  
    public appUIService:EAMLocationUIService = new EAMLocationUIService(this.$store);


    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof EF_001EditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        locationnumber: null,
        eamlocationname: null,
        eamlocationtypename: null,
        eamlocationid: null,
        eamlocationtypeid: null,
        eamlocation:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof EF_001EditFormBase
     */
    public rules: any = {
        locationnumber: [
            { required: true, type: 'string', message: '功能位置编号 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '功能位置编号 值不能为空', trigger: 'blur' },
        ],
        eamlocationname: [
            { required: true, type: 'string', message: '功能位置名称 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '功能位置名称 值不能为空', trigger: 'blur' },
        ],
        eamlocationtypename: [
            { required: true, type: 'string', message: '功能位置类型 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '功能位置类型 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof EF_001Base
     */
    public deRules:any = {
    };

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof EF_001EditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '功能位置基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.eamlocation.ef_001_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this, showMoreMode: 0 }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '功能位置标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfmajortext: new FormItemModel({ caption: '功能位置名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        locationnumber: new FormItemModel({ caption: '功能位置编号', detailType: 'FORMITEM', name: 'locationnumber', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamlocationname: new FormItemModel({ caption: '功能位置名称', detailType: 'FORMITEM', name: 'eamlocationname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamlocationtypename: new FormItemModel({ caption: '功能位置类型', detailType: 'FORMITEM', name: 'eamlocationtypename', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamlocationid: new FormItemModel({ caption: '功能位置标识', detailType: 'FORMITEM', name: 'eamlocationid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamlocationtypeid: new FormItemModel({ caption: '功能位置类型标识', detailType: 'FORMITEM', name: 'eamlocationtypeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

    };
}