import { Subject } from 'rxjs';
import { PickupViewBase } from '@/studio-core';
import EAMLocationTypeService from '@/service/eamlocation-type/eamlocation-type-service';
import EAMLocationTypeAuthService from '@/authservice/eamlocation-type/eamlocation-type-auth-service';
import PickupViewEngine from '@engine/view/pickup-view-engine';
import EAMLocationTypeUIService from '@/uiservice/eamlocation-type/eamlocation-type-ui-service';

/**
 * 功能位置类型数据选择视图视图基类
 *
 * @export
 * @class EAMLocationTypePickupViewBase
 * @extends {PickupViewBase}
 */
export class EAMLocationTypePickupViewBase extends PickupViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationTypePickupViewBase
     */
    protected appDeName: string = 'eamlocationtype';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationTypePickupViewBase
     */
    protected appDeKey: string = 'eamlocationtypeid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationTypePickupViewBase
     */
    protected appDeMajor: string = 'eamlocationtypename';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationTypeService}
     * @memberof EAMLocationTypePickupViewBase
     */
    protected appEntityService: EAMLocationTypeService = new EAMLocationTypeService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationTypeUIService
     * @memberof EAMLocationTypePickupViewBase
     */
    public appUIService: EAMLocationTypeUIService = new EAMLocationTypeUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationTypePickupViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationTypePickupViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocationtype.views.pickupview.caption',
        srfTitle: 'entities.eamlocationtype.views.pickupview.title',
        srfSubTitle: 'entities.eamlocationtype.views.pickupview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationTypePickupViewBase
     */
    protected containerModel: any = {
        view_pickupviewpanel: { name: 'pickupviewpanel', type: 'PICKUPVIEWPANEL' },
        view_okbtn: { name: 'okbtn', type: 'button', text: '确定', disabled: true },
        view_cancelbtn: { name: 'cancelbtn', type: 'button', text: '取消', disabled: false },
        view_leftbtn: { name: 'leftbtn', type: 'button', text: '左移', disabled: true },
        view_rightbtn: { name: 'rightbtn', type: 'button', text: '右移', disabled: true },
        view_allleftbtn: { name: 'allleftbtn', type: 'button', text: '全部左移', disabled: true },
        view_allrightbtn: { name: 'allrightbtn', type: 'button', text: '全部右移', disabled: true },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '4a5dd0204cc256862db03b36fc570e71';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationTypePickupViewBase
     */
    public engine: PickupViewEngine = new PickupViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationTypePickupViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            pickupviewpanel: this.$refs.pickupviewpanel,
            keyPSDEField: 'eamlocationtype',
            majorPSDEField: 'eamlocationtypename',
            isLoadDefault: true,
        });
    }

    /**
     * pickupviewpanel 部件 selectionchange 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTypePickupViewBase
     */
    public pickupviewpanel_selectionchange($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'selectionchange', $event);
    }

    /**
     * pickupviewpanel 部件 activated 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTypePickupViewBase
     */
    public pickupviewpanel_activated($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'activated', $event);
    }

    /**
     * pickupviewpanel 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTypePickupViewBase
     */
    public pickupviewpanel_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'load', $event);
    }


}