import { Subject } from 'rxjs';
import { PickupGridViewBase } from '@/studio-core';
import EAMLocationTypeService from '@/service/eamlocation-type/eamlocation-type-service';
import EAMLocationTypeAuthService from '@/authservice/eamlocation-type/eamlocation-type-auth-service';
import PickupGridViewEngine from '@engine/view/pickup-grid-view-engine';
import EAMLocationTypeUIService from '@/uiservice/eamlocation-type/eamlocation-type-ui-service';

/**
 * 功能位置类型选择表格视图视图基类
 *
 * @export
 * @class EAMLocationTypePickupGridViewBase
 * @extends {PickupGridViewBase}
 */
export class EAMLocationTypePickupGridViewBase extends PickupGridViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationTypePickupGridViewBase
     */
    protected appDeName: string = 'eamlocationtype';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationTypePickupGridViewBase
     */
    protected appDeKey: string = 'eamlocationtypeid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationTypePickupGridViewBase
     */
    protected appDeMajor: string = 'eamlocationtypename';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationTypeService}
     * @memberof EAMLocationTypePickupGridViewBase
     */
    protected appEntityService: EAMLocationTypeService = new EAMLocationTypeService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationTypeUIService
     * @memberof EAMLocationTypePickupGridViewBase
     */
    public appUIService: EAMLocationTypeUIService = new EAMLocationTypeUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationTypePickupGridViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationTypePickupGridViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocationtype.views.pickupgridview.caption',
        srfTitle: 'entities.eamlocationtype.views.pickupgridview.title',
        srfSubTitle: 'entities.eamlocationtype.views.pickupgridview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationTypePickupGridViewBase
     */
    protected containerModel: any = {
        view_grid: { name: 'grid', type: 'GRID' },
        view_searchform: { name: 'searchform', type: 'SEARCHFORM' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '6a395ea52232233416d9c7120518863d';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationTypePickupGridViewBase
     */
    public engine: PickupGridViewEngine = new PickupGridViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationTypePickupGridViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            grid: this.$refs.grid,
            searchform: this.$refs.searchform,
            keyPSDEField: 'eamlocationtype',
            majorPSDEField: 'eamlocationtypename',
            isLoadDefault: true,
        });
    }

    /**
     * grid 部件 selectionchange 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTypePickupGridViewBase
     */
    public grid_selectionchange($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'selectionchange', $event);
    }

    /**
     * grid 部件 beforeload 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTypePickupGridViewBase
     */
    public grid_beforeload($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'beforeload', $event);
    }

    /**
     * grid 部件 rowdblclick 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTypePickupGridViewBase
     */
    public grid_rowdblclick($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'rowdblclick', $event);
    }

    /**
     * grid 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTypePickupGridViewBase
     */
    public grid_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'load', $event);
    }

    /**
     * searchform 部件 save 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTypePickupGridViewBase
     */
    public searchform_save($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('searchform', 'save', $event);
    }

    /**
     * searchform 部件 search 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTypePickupGridViewBase
     */
    public searchform_search($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('searchform', 'search', $event);
    }

    /**
     * searchform 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTypePickupGridViewBase
     */
    public searchform_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('searchform', 'load', $event);
    }



    /**
     * 是否展开搜索表单
     *
     * @protected
     * @type {boolean}
     * @memberof EAMLocationTypePickupGridViewBase
     */
    protected isExpandSearchForm: boolean = true;


}