import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';
import { globalRoutes, indexRoutes} from '@/router'
import { AppService } from '@/studio-core/service/app-service/AppService';

Vue.use(Router);

const appService = new AppService();

const router = new Router({
    routes: [
        {
            path: '/appindexview/:appindexview?',
            beforeEnter: async (to: any, from: any, next: any) => {
                const routerParamsName = 'appindexview';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    params[routerParamsName] = to.params[routerParamsName];
                }
                const url: string = '/appdata';
                await AuthGuard.getInstance().authGuard(url, params, router);
                appService.navHistory.indexMeta = {
                    caption: 'app.views.appindexview.title',
                    info:'',
                    viewType: 'APPINDEX',
                    parameters: [
                        { pathName: 'appindexview', parameterName: 'appindexview' },
                    ],
                    requireAuth: true,
                };
                next();
            },
            meta: {  
                caption: 'app.views.appindexview.title',
                info:'',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'appindexview', parameterName: 'appindexview' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/base/app-index-view/app-index-view.vue'),
            children: [
                {
                    path: 'eamassettypes/:eamassettype?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamassettype.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassettypes', parameterName: 'eamassettype' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-type-pickup-view/eamasset-type-pickup-view.vue'),
                },
                {
                    path: 'eamassetstatemodellines/:eamassetstatemodelline?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamassetstatemodelline.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstatemodellines', parameterName: 'eamassetstatemodelline' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-model-line-edit-view/eamasset-state-model-line-edit-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/eamassets/:eamasset?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.eamasset.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-tree-exp-view/eamasset-tree-exp-view.vue'),
                },
                {
                    path: 'eamassets/:eamasset?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.eamasset.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-tree-exp-view/eamasset-tree-exp-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/eamassets/:eamasset?/childgridview/:childgridview?',
                    meta: {
                        caption: 'entities.eamasset.views.childgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'childgridview', parameterName: 'childgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-child-grid-view/eamasset-child-grid-view.vue'),
                },
                {
                    path: 'eamassets/:eamasset?/childgridview/:childgridview?',
                    meta: {
                        caption: 'entities.eamasset.views.childgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'childgridview', parameterName: 'childgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-child-grid-view/eamasset-child-grid-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocation.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-edit-view/eamlocation-edit-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.eamlocation.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-tree-exp-view/eamlocation-tree-exp-view.vue'),
                },
                {
                    path: 'eamassetstates/:eamassetstate?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamassetstate.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstates', parameterName: 'eamassetstate' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-edit-view/eamasset-state-edit-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/treechildgridview/:treechildgridview?',
                    meta: {
                        caption: 'entities.eamlocation.views.treechildgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'treechildgridview', parameterName: 'treechildgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-tree-child-grid-view/eamlocation-tree-child-grid-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-pickup-grid-view/eamlocation-state-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/eamassets/:eamasset?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamasset.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-grid-view/eamasset-grid-view.vue'),
                },
                {
                    path: 'eamassets/:eamasset?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamasset.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-grid-view/eamasset-grid-view.vue'),
                },
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-pickup-grid-view/eamlocation-state-model-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamlocation.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-pickup-view/eamlocation-pickup-view.vue'),
                },
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-pickup-view/eamlocation-state-model-pickup-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-pickup-view/eamlocation-state-pickup-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/info_mainview/:info_mainview?',
                    meta: {
                        caption: 'entities.eamlocation.views.info_mainview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'info_mainview', parameterName: 'info_mainview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-info-main-view/eamlocation-info-main-view.vue'),
                },
                {
                    path: 'eamassetstates/:eamassetstate?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamassetstate.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstates', parameterName: 'eamassetstate' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-pickup-view/eamasset-state-pickup-view.vue'),
                },
                {
                    path: 'eamassetstates/:eamassetstate?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamassetstate.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstates', parameterName: 'eamassetstate' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-grid-view/eamasset-state-grid-view.vue'),
                },
                {
                    path: 'eamlocationtypes/:eamlocationtype?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamlocationtype.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationtypes', parameterName: 'eamlocationtype' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-type-pickup-view/eamlocation-type-pickup-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/eamassets/:eamasset?/info_mainview/:info_mainview?',
                    meta: {
                        caption: 'entities.eamasset.views.info_mainview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'info_mainview', parameterName: 'info_mainview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-info-main-view/eamasset-info-main-view.vue'),
                },
                {
                    path: 'eamassets/:eamasset?/info_mainview/:info_mainview?',
                    meta: {
                        caption: 'entities.eamasset.views.info_mainview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'info_mainview', parameterName: 'info_mainview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-info-main-view/eamasset-info-main-view.vue'),
                },
                {
                    path: 'eamassetstatemodels/:eamassetstatemodel?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamassetstatemodel.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstatemodels', parameterName: 'eamassetstatemodel' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-model-grid-view/eamasset-state-model-grid-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/eamassets/:eamasset?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamasset.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-edit-view/eamasset-edit-view.vue'),
                },
                {
                    path: 'eamassets/:eamasset?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamasset.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-edit-view/eamasset-edit-view.vue'),
                },
                {
                    path: 'eamassettypes/:eamassettype?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamassettype.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassettypes', parameterName: 'eamassettype' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-type-grid-view/eamasset-type-grid-view.vue'),
                },
                {
                    path: 'eamassetstatemodels/:eamassetstatemodel?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamassetstatemodel.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstatemodels', parameterName: 'eamassetstatemodel' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-model-pickup-grid-view/eamasset-state-model-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/eamassets/:eamasset?/locationassetgridview/:locationassetgridview?',
                    meta: {
                        caption: 'entities.eamasset.views.locationassetgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'locationassetgridview', parameterName: 'locationassetgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-location-asset-grid-view/eamasset-location-asset-grid-view.vue'),
                },
                {
                    path: 'eamassets/:eamasset?/locationassetgridview/:locationassetgridview?',
                    meta: {
                        caption: 'entities.eamasset.views.locationassetgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'locationassetgridview', parameterName: 'locationassetgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-location-asset-grid-view/eamasset-location-asset-grid-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.eamlocation.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-info-view/eamlocation-info-view.vue'),
                },
                {
                    path: 'eamlocationtypes/:eamlocationtype?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamlocationtype.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationtypes', parameterName: 'eamlocationtype' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-type-pickup-grid-view/eamlocation-type-pickup-grid-view.vue'),
                },
                {
                    path: 'eamassettypes/:eamassettype?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamassettype.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassettypes', parameterName: 'eamassettype' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-type-edit-view/eamasset-type-edit-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/eamassets/:eamasset?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.eamasset.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-summary-view/eamasset-summary-view.vue'),
                },
                {
                    path: 'eamassets/:eamasset?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.eamasset.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-summary-view/eamasset-summary-view.vue'),
                },
                {
                    path: 'eamassetstatemodellines/:eamassetstatemodelline?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamassetstatemodelline.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstatemodellines', parameterName: 'eamassetstatemodelline' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-model-line-grid-view/eamasset-state-model-line-grid-view.vue'),
                },
                {
                    path: 'eamlocationtypes/:eamlocationtype?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamlocationtype.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationtypes', parameterName: 'eamlocationtype' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-type-grid-view/eamlocation-type-grid-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-edit-view/eamlocation-state-edit-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/eamassets/:eamasset?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.eamasset.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-info-view/eamasset-info-view.vue'),
                },
                {
                    path: 'eamassets/:eamasset?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.eamasset.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-info-view/eamasset-info-view.vue'),
                },
                {
                    path: 'eamassetstatemodels/:eamassetstatemodel?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamassetstatemodel.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstatemodels', parameterName: 'eamassetstatemodel' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-model-edit-view/eamasset-state-model-edit-view.vue'),
                },
                {
                    path: 'eamassetstates/:eamassetstate?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamassetstate.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstates', parameterName: 'eamassetstate' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-pickup-grid-view/eamasset-state-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-edit-view/eamlocation-state-model-edit-view.vue'),
                },
                {
                    path: 'eamassetstatemodels/:eamassetstatemodel?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamassetstatemodel.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstatemodels', parameterName: 'eamassetstatemodel' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-model-pickup-view/eamasset-state-model-pickup-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/eamassets/:eamasset?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamasset.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-pickup-grid-view/eamasset-pickup-grid-view.vue'),
                },
                {
                    path: 'eamassets/:eamasset?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamasset.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-pickup-grid-view/eamasset-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocationstatemodellines/:eamlocationstatemodelline?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodelline.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodellines', parameterName: 'eamlocationstatemodelline' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-line-edit-view/eamlocation-state-model-line-edit-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/childgridview/:childgridview?',
                    meta: {
                        caption: 'entities.eamlocation.views.childgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'childgridview', parameterName: 'childgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-child-grid-view/eamlocation-child-grid-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/listexpview/:listexpview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.listexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'listexpview', parameterName: 'listexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-list-exp-view/eamlocation-state-list-exp-view.vue'),
                },
                {
                    path: 'eamlocationstatemodellines/:eamlocationstatemodelline?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodelline.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodellines', parameterName: 'eamlocationstatemodelline' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-line-grid-view/eamlocation-state-model-line-grid-view.vue'),
                },
                {
                    path: 'eamlocationtypes/:eamlocationtype?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocationtype.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationtypes', parameterName: 'eamlocationtype' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-type-edit-view/eamlocation-type-edit-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamlocation.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-pickup-grid-view/eamlocation-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.eamlocation.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-summary-view/eamlocation-summary-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/eamassets/:eamasset?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.eamasset.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-quick-create-view/eamasset-quick-create-view.vue'),
                },
                {
                    path: 'eamassets/:eamasset?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.eamasset.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-quick-create-view/eamasset-quick-create-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/eamassets/:eamasset?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamasset.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-pickup-view/eamasset-pickup-view.vue'),
                },
                {
                    path: 'eamassets/:eamasset?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamasset.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassets', parameterName: 'eamasset' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-pickup-view/eamasset-pickup-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamlocation.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-grid-view/eamlocation-grid-view.vue'),
                },
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-grid-view/eamlocation-state-model-grid-view.vue'),
                },
                {
                    path: 'eamassettypes/:eamassettype?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamassettype.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassettypes', parameterName: 'eamassettype' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-type-pickup-grid-view/eamasset-type-pickup-grid-view.vue'),
                },
            ...indexRoutes,
            ],
        },
        ...globalRoutes,
        {
            path: '/login/:login?',
            name: 'login',
            meta: {  
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                appService.navHistory.reset();
                next();
            },
            component: () => import('@components/login/login'),
        },
        {
            path: '/404',
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            component: () => import('@components/500/500.vue')
        },
        {
            path: '*',
            redirect: 'appindexview'
        }
    ]
});

router.beforeEach((to: any, from: any, next: any) => {
    if (to.meta && !to.meta.ignoreAddPage) {
        appService.navHistory.add(to);
    }
    next();
});

export default router;