import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import EAMLocationService from '@/service/eamlocation/eamlocation-service';
import MainService from './main-grid-service';
import EAMLocationUIService from '@/uiservice/eamlocation/eamlocation-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {EAMLocationService}
     * @memberof MainGridBase
     */
    public appEntityService: EAMLocationService = new EAMLocationService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'eamlocation';

    /**
     * 界面UI服务对象
     *
     * @type {EAMLocationUIService}
     * @memberof MainBase
     */  
    public appUIService:EAMLocationUIService = new EAMLocationUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'eamlocation_main_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'locationnumber',
            label: '功能位置编号',
            langtag: 'entities.eamlocation.main_grid.columns.locationnumber',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'eamlocationname',
            label: '功能位置名称',
            langtag: 'entities.eamlocation.main_grid.columns.eamlocationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'eamlocationtypename',
            label: '功能位置类型',
            langtag: 'entities.eamlocation.main_grid.columns.eamlocationtypename',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'peamlocationname',
            label: '上级位置',
            langtag: 'entities.eamlocation.main_grid.columns.peamlocationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'eamlocationstatename',
            label: '功能位置状态',
            langtag: 'entities.eamlocation.main_grid.columns.eamlocationstatename',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '功能位置标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '功能位置标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'locationnumber':false,
        'eamlocationname':false,
        'eamlocationtypename':false,
        'peamlocationname':false,
        'eamlocationstatename':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
        ]);
    }

}