import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';
import { globalRoutes, indexRoutes} from '@/router'
import { AppService } from '@/studio-core/service/app-service/AppService';

Vue.use(Router);

const appService = new AppService();

const router = new Router({
    routes: [
        {
            path: '/appindexview/:appindexview?',
            beforeEnter: async (to: any, from: any, next: any) => {
                const routerParamsName = 'appindexview';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    params[routerParamsName] = to.params[routerParamsName];
                }
                const url: string = '/appdata';
                await AuthGuard.getInstance().authGuard(url, params, router);
                appService.navHistory.indexMeta = {
                    caption: 'app.views.appindexview.title',
                    info:'',
                    viewType: 'APPINDEX',
                    parameters: [
                        { pathName: 'appindexview', parameterName: 'appindexview' },
                    ],
                    requireAuth: true,
                };
                next();
            },
            meta: {  
                caption: 'app.views.appindexview.title',
                info:'',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'appindexview', parameterName: 'appindexview' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/base/app-index-view/app-index-view.vue'),
            children: [
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-pickup-grid-view/eamlocation-state-model-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocationstatemodellines/:eamlocationstatemodelline?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodelline.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodellines', parameterName: 'eamlocationstatemodelline' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-line-edit-view/eamlocation-state-model-line-edit-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-edit-view/eamlocation-state-edit-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-grid-view/eamlocation-state-grid-view.vue'),
                },
                {
                    path: 'eamlocationstatemodellines/:eamlocationstatemodelline?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodelline.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodellines', parameterName: 'eamlocationstatemodelline' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-line-grid-view/eamlocation-state-model-line-grid-view.vue'),
                },
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-grid-view/eamlocation-state-model-grid-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-pickup-grid-view/eamlocation-state-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-pickup-view/eamlocation-state-model-pickup-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-pickup-view/eamlocation-state-pickup-view.vue'),
                },
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-edit-view/eamlocation-state-model-edit-view.vue'),
                },
            ...indexRoutes,
            ],
        },
        ...globalRoutes,
        {
            path: '/login/:login?',
            name: 'login',
            meta: {  
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                appService.navHistory.reset();
                next();
            },
            component: () => import('@components/login/login'),
        },
        {
            path: '/404',
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            component: () => import('@components/500/500.vue')
        },
        {
            path: '*',
            redirect: 'appindexview'
        }
    ]
});

router.beforeEach((to: any, from: any, next: any) => {
    if (to.meta && !to.meta.ignoreAddPage) {
        appService.navHistory.add(to);
    }
    next();
});

export default router;