/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'workordername',
          prop: 'workordername',
          dataType: 'TEXT',
        },
        {
          name: 'eamservicelevelid',
          prop: 'eamservicelevelid',
          dataType: 'PICKUP',
        },
        {
          name: 'pworkorderid',
          prop: 'pworkorderid',
          dataType: 'PICKUP',
        },
        {
          name: 'eamwotypename',
          prop: 'eamwotypename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'workordername',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'workorderid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'workorderid',
          dataType: 'GUID',
        },
        {
          name: 'wonumber',
          prop: 'wonumber',
          dataType: 'TEXT',
        },
        {
          name: 'eamlocationname',
          prop: 'eamlocationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eamlocationid',
          prop: 'eamlocationid',
          dataType: 'PICKUP',
        },
        {
          name: 'eamwooriginname',
          prop: 'wooriginname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'wodate',
          prop: 'wodate',
          dataType: 'DATETIME',
        },
        {
          name: 'eamwotypeid',
          prop: 'eamwotypeid',
          dataType: 'PICKUP',
        },
        {
          name: 'eamwooriginid',
          prop: 'wooriginid',
          dataType: 'PICKUP',
        },
        {
          name: 'assetid',
          prop: 'assetid',
          dataType: 'PICKUP',
        },
        {
          name: 'assetname',
          prop: 'assetname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eamworkorder',
          prop: 'workorderid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}