import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import EAMWorkOrderService from '@/service/eamwork-order/eamwork-order-service';
import DataPanelIFService from './data-panel-if-form-service';
import EAMWorkOrderUIService from '@/uiservice/eamwork-order/eamwork-order-ui-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * datapanel部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {DataPanelIFEditFormBase}
 */
export class DataPanelIFEditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof DataPanelIFEditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {DataPanelIFService}
     * @memberof DataPanelIFEditFormBase
     */
    public service: DataPanelIFService = new DataPanelIFService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {EAMWorkOrderService}
     * @memberof DataPanelIFEditFormBase
     */
    public appEntityService: EAMWorkOrderService = new EAMWorkOrderService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof DataPanelIFEditFormBase
     */
    protected appDeName: string = 'eamworkorder';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof DataPanelIFEditFormBase
     */
    protected appDeLogicName: string = '工单';

    /**
     * 逻辑事件
     *
     * @param {*} [params={}]
     * @param {*} [tag]
     * @param {*} [$event]
     * @memberof 
     */
    public datapanel_button1_click(params: any = {}, tag?: any, $event?: any) {
        // 取数
        let datas: any[] = [];
        let xData: any = null;
        // _this 指向容器对象
        const _this: any = this;
        let paramJO:any = {};
        let contextJO:any = {};
        xData = this;
        if (_this.getDatas && _this.getDatas instanceof Function) {
            datas = [..._this.getDatas()];
        }
        if(params){
          datas = [params];
        }
        // 界面行为
        const curUIService:EAMWorkOrderUIService  = new EAMWorkOrderUIService();
        curUIService.EAMWorkOrder_DataPanelEdit(datas,contextJO, paramJO,  $event, xData,this,"EAMWorkOrder");
    }
    /**
     * 界面UI服务对象
     *
     * @type {EAMWorkOrderUIService}
     * @memberof DataPanelIFEditFormBase
     */  
    public appUIService:EAMWorkOrderUIService = new EAMWorkOrderUIService(this.$store);


    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof DataPanelIFEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        eamwotypename: null,
        eamservicelevelname: null,
        workorderid: null,
        eamworkorder:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof DataPanelIFEditFormBase
     */
    public rules: any = {
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof DataPanelIFBase
     */
    public deRules:any = {
    };

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof DataPanelIFEditFormBase
     */
    public detailsModel: any = {
        button1: new FormButtonModel({ caption: '头信息编辑', detailType: 'BUTTON', name: 'button1', visible: true, isShowCaption: false, form: this, showMoreMode: 0, uiaction: { type: 'DEUIACTION', tag: 'DataPanelEdit', actiontarget: 'SINGLEKEY' } }),

        grouppanel1: new FormGroupPanelModel({ caption: '分组面板', detailType: 'GROUPPANEL', name: 'grouppanel1', visible: true, isShowCaption: false, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.eamworkorder.datapanelif_form', extractMode: 'ITEM', details: [] } }),

        group1: new FormGroupPanelModel({ caption: '工单基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.eamworkorder.datapanelif_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this, showMoreMode: 0 }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '工单标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfmajortext: new FormItemModel({ caption: '工单名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamwotypename: new FormItemModel({ caption: '工单类型', detailType: 'FORMITEM', name: 'eamwotypename', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamservicelevelname: new FormItemModel({ caption: '服务等级', detailType: 'FORMITEM', name: 'eamservicelevelname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        workorderid: new FormItemModel({ caption: '工单标识', detailType: 'FORMITEM', name: 'workorderid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

    };

	/**
	 * 表单 头信息编辑 事件
	 *
	 * @memberof @memberof DataPanelIFEditFormBase
	 */
    public button1_click($event: any): void {
        this.datapanel_button1_click(null, null, $event);

    }
}